package com.java24hours;

import java.io.*;
import java.net.*;
import jdk.incubator.http.*;

public class SalutonVerkisto {
    
    public SalutonVerkisto() {
        String site = "http://workbench.cadenhead.org/post-a-comment.php";
        try {
            postMessage(site);
        } catch (URISyntaxException oops) {
            System.out.println("Ze URI: " + oops.getMessage());
        } catch (IOException | InterruptedException oops) {
            System.out.println("Bd: " + oops.getMessage());
        }
    }
    
    public void postMessage(String server) throws IOException,
            URISyntaxException, InterruptedException {
        
        HttpClient client = HttpClient.newHttpClient();

        // Adres serwera
        URI uri = new URI(server);
        
        // Przygotuj komunikat 
        String yourName = "Pan Tadeusz z Soplicowa";
        String yourMessage = "Moim skromnym zdaniem ta publikacja jest bardzo dobra.";
        
        // Ustaw kodowanie komunikatu
        HttpRequest.BodyProcessor proc = HttpRequest.BodyProcessor.fromString(
            "name=" + URLEncoder.encode(yourName, "ISO-8859-2") +
            "&comment=" + URLEncoder.encode(yourMessage, "ISO-8859-2") +
            "&mode=" + URLEncoder.encode("demo", "ISO-8859-2")
        );
        
        // Przygotuj danie
        HttpRequest.Builder newBuilder = HttpRequest.newBuilder(uri)
            .header("Content-Type", "application/x-www-form-urlencoded")
            .header("Accept", "text/plain")
            .POST(proc);
        
        // Utwrz danie
        HttpRequest request = newBuilder.build();
        
        // Odbierz odpowied serwera
        System.out.println("Metoda: " + request.method() + "\n");
        HttpResponse<String> response = client.send(request,
            HttpResponse.BodyHandler.asString());
        System.out.println(response.body());
    }

    public static void main(String[] arguments) {
        new SalutonVerkisto();
    }
}
